/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.server.command.impl;

import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.info.LimitationByServer;
import com.alrex.parcool.server.command.args.ActionArgumentType;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class ChangeIndividualLimitationCommand {
    private static final String ARGS_NAME_PLAYERS = "targets";
    private static final String ARGS_NAME_ACTION = "action";
    private static final String ARGS_NAME_MAX_STAMINA_VALUE = "max_stamina_value";
    private static final String ARGS_NAME_STAMINA_CONSUMPTION = "stamina_consumption";
    private static final String ARGS_NAME_POSSIBILITY = "possibility";

    public static ArgumentBuilder<CommandSourceStack, ?> getBuilder() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"limitation").requires(commandSource -> commandSource.m_6761_(2))).then(Commands.m_82127_((String)"enable").then(Commands.m_82129_((String)ARGS_NAME_PLAYERS, (ArgumentType)EntityArgument.m_91470_()).executes(ChangeIndividualLimitationCommand::enableLimitation)))).then(Commands.m_82127_((String)"disable").then(Commands.m_82129_((String)ARGS_NAME_PLAYERS, (ArgumentType)EntityArgument.m_91470_()).executes(ChangeIndividualLimitationCommand::disableLimitation)))).then(Commands.m_82127_((String)"set").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)ARGS_NAME_PLAYERS, (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82127_((String)"to_default").executes(ChangeIndividualLimitationCommand::setLimitationDefault))).then(Commands.m_82127_((String)"max_stamina").then(Commands.m_82129_((String)ARGS_NAME_MAX_STAMINA_VALUE, (ArgumentType)IntegerArgumentType.integer((int)0, (int)Integer.MAX_VALUE)).executes(ChangeIndividualLimitationCommand::changeLimitationOfMaxStamina)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)ARGS_NAME_POSSIBILITY).then(Commands.m_82127_((String)"infinite_stamina").then(Commands.m_82129_((String)ARGS_NAME_POSSIBILITY, (ArgumentType)BoolArgumentType.bool()).executes(ChangeIndividualLimitationCommand::changePossibilityOfInfiniteStamina)))).then(Commands.m_82129_((String)ARGS_NAME_ACTION, (ArgumentType)ActionArgumentType.action()).then(Commands.m_82129_((String)ARGS_NAME_POSSIBILITY, (ArgumentType)BoolArgumentType.bool()).executes(ChangeIndividualLimitationCommand::changePossibilityOfAction))))).then(Commands.m_82127_((String)"least_stamina_consumption").then(Commands.m_82129_((String)ARGS_NAME_ACTION, (ArgumentType)ActionArgumentType.action()).then(Commands.m_82129_((String)ARGS_NAME_STAMINA_CONSUMPTION, (ArgumentType)IntegerArgumentType.integer((int)0, (int)Integer.MAX_VALUE)).executes(ChangeIndividualLimitationCommand::changeStaminaConsumption))))));
    }

    private static int setLimitationDefault(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection targets = EntityArgument.m_91477_(context, (String)ARGS_NAME_PLAYERS);
        int num = 0;
        for (ServerPlayer player : targets) {
            new LimitationByServer.IndividualLimitationChanger(player).setDefault().sync();
            ++num;
        }
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"parcool.command.message.success.setLimitationToDefault", (Object[])new Object[]{num}), true);
        return 0;
    }

    private static int enableLimitation(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection targets = EntityArgument.m_91477_(context, (String)ARGS_NAME_PLAYERS);
        int num = 0;
        for (ServerPlayer player : targets) {
            new LimitationByServer.IndividualLimitationChanger(player).setEnforced(true).sync();
            ++num;
        }
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"parcool.command.message.success.enableLimitation", (Object[])new Object[]{num}), true);
        return 0;
    }

    private static int disableLimitation(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection targets = EntityArgument.m_91477_(context, (String)ARGS_NAME_PLAYERS);
        int num = 0;
        for (ServerPlayer player : targets) {
            new LimitationByServer.IndividualLimitationChanger(player).setEnforced(false).sync();
            ++num;
        }
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"parcool.command.message.success.disableLimitation", (Object[])new Object[]{num}), true);
        return 0;
    }

    private static int changeLimitationOfMaxStamina(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection targets = EntityArgument.m_91477_(context, (String)ARGS_NAME_PLAYERS);
        int newValue = IntegerArgumentType.getInteger(context, (String)ARGS_NAME_MAX_STAMINA_VALUE);
        int num = 0;
        for (ServerPlayer player : targets) {
            new LimitationByServer.IndividualLimitationChanger(player).setMaxStaminaLimitation(newValue).sync();
            ++num;
        }
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"parcool.command.message.success.setMaxStamina", (Object[])new Object[]{num, newValue}), true);
        return 0;
    }

    private static int changeStaminaConsumption(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection targets = EntityArgument.m_91477_(context, (String)ARGS_NAME_PLAYERS);
        Class<? extends Action> action = ActionArgumentType.getAction(context, ARGS_NAME_ACTION);
        int newValue = IntegerArgumentType.getInteger(context, (String)ARGS_NAME_STAMINA_CONSUMPTION);
        int num = 0;
        for (ServerPlayer player : targets) {
            new LimitationByServer.IndividualLimitationChanger(player).setStaminaConsumptionOf(action, newValue).sync();
            ++num;
        }
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"parcool.command.message.success.setStaminaConsumption", (Object[])new Object[]{num, action.getSimpleName(), newValue}), true);
        return 0;
    }

    private static int changePossibilityOfInfiniteStamina(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection targets = EntityArgument.m_91477_(context, (String)ARGS_NAME_PLAYERS);
        boolean newValue = BoolArgumentType.getBool(context, (String)ARGS_NAME_POSSIBILITY);
        int num = 0;
        for (ServerPlayer player : targets) {
            new LimitationByServer.IndividualLimitationChanger(player).setInfiniteStaminaPermission(newValue).sync();
            ++num;
        }
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"parcool.command.message.success.setPermissionInfiniteStamina", (Object[])new Object[]{num, newValue}), true);
        return 0;
    }

    private static int changePossibilityOfAction(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection targets = EntityArgument.m_91477_(context, (String)ARGS_NAME_PLAYERS);
        Class<? extends Action> action = ActionArgumentType.getAction(context, ARGS_NAME_ACTION);
        boolean newValue = BoolArgumentType.getBool(context, (String)ARGS_NAME_POSSIBILITY);
        int num = 0;
        for (ServerPlayer player : targets) {
            new LimitationByServer.IndividualLimitationChanger(player).setPossibilityOf(action, newValue).sync();
            ++num;
        }
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"parcool.command.message.success.setPermissionOfAction", (Object[])new Object[]{num, action.getSimpleName(), newValue}), true);
        return 0;
    }
}

